<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attribute for schema type plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class SchemaType extends Plugin {

  /**
   * Constructs a new schema type plugin.
   *
   * @param string $id
   *   The machine name of the schema type. eg Address.
   * @param class-string|null $deriver
   *   (optional) The deriver class for the entity type.
   * @param array $third_party_settings
   *   (optional) Third party settings.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?string $deriver = NULL,
    public readonly array $third_party_settings = [],
  ) {}

}
