<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\EntityType;

use Drupal\graphql_compose\Attribute\EntityType;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeEntityTypeBase;

/**
 * {@inheritdoc}
 */
#[EntityType(
  id: "taxonomy_term",
  type_sdl: "Term",
  prefix: "Term",
  base_fields: [
    "langcode" => [],
    "created" => [],
    "changed" => [],
    "path" => [],
    "status" => [],
    "weight" => [],
    "parent" => [
      "required" => FALSE,
      "multiple" => FALSE,
    ],
    "name" => [
      "field_type" => "entity_label",
    ],
    "description" => [
      "field_type" => "text",
    ],
  ],
)]
class TaxonomyTerm extends GraphQLComposeEntityTypeBase {

}
