<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\FieldType;

use Drupal\Core\Entity\EntityInterface;
use Drupal\graphql\GraphQL\Resolver\Composite;
use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql_compose\Attribute\FieldType;
use Drupal\graphql_compose\Utility\ComposeConfig;

/**
 * {@inheritdoc}
 */
#[FieldType(
  id: "entity_reference_target_id",
  type_sdl: "ID",
)]
class EntityReferenceTargetIdItem extends EntityReferenceItem {

  /**
   * {@inheritdoc}
   */
  public function isSingleUnion(): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getProducers(ResolverBuilder $builder): Composite {
    // Use the parent producers to use the buffers for entity loading.
    $composite = parent::getProducers($builder);

    // Users select how they want to display ids.
    $expose_entity_ids = ComposeConfig::get('settings.expose_entity_ids', FALSE);

    // Get the entity reference target id.
    $composite->add(
      $builder->callback(fn (?array $entities) => array_map(
        fn (EntityInterface $entity) => $expose_entity_ids
          ? $entity->id()
          : $entity->uuid(),
        $entities ?: []
      ))
    );

    return $composite;
  }

}
