<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\FieldType;

use Drupal\graphql_compose\Attribute\FieldType;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql_compose\Plugin\GraphQL\DataProducer\FieldProducerItemInterface;
use Drupal\graphql_compose\Plugin\GraphQL\DataProducer\FieldProducerTrait;

/**
 * {@inheritdoc}
 */
#[FieldType(
  id: "smartdate",
  type_sdl: "SmartDate",
)]
class SmartDateItem extends DateTimeItem implements FieldProducerItemInterface {

  use FieldProducerTrait;

  /**
   * {@inheritdoc}
   */
  public function resolveFieldItem(FieldItemInterface $item, FieldContext $context) {

    $result = [
      'start' => $item->start_time ? $this->toDateTimeType($item->start_time) : NULL,
      'end' => $item->end_time ? $this->toDateTimeType($item->end_time) : NULL,
      'duration' => is_null($item->duration) ? NULL : (float) $item->duration,
      'timezone' => $item->timezone ?: NULL,
    ];

    if (!$this->moduleHandler->moduleExists('smart_date_recur')) {
      return $result;
    }

    $result['recurrence'] = [];

    if ($item->rrule) {
      /** @var \Drupal\smart_date_recur\Entity\SmartDateRule $rrule */
      $rrule = $this->entityTypeManager
        ->getStorage('smart_date_rule')
        ->load($item->rrule);

      if ($rrule) {
        foreach ($rrule->getRuleInstances() as $instance) {
          $start_date = $this->toDrupalDateTime($instance['value'] ?? NULL);
          $end_date = $this->toDrupalDateTime($instance['end_value'] ?? NULL);

          $result['recurrence'][] = [
            'start' => $start_date ? $this->toDateTimeType($start_date) : NULL,
            'end' => $end_date ? $this->toDateTimeType($end_date) : NULL,
          ];
        }
      }
    }

    return $result;
  }

}
