<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Attribute\SchemaType;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\Type;

/**
 * {@inheritdoc}
 */
#[SchemaType(
  id: "Geomap",
)]
class GeomapType extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getTypes(): array {
    $types = [];

    if (!$this->moduleHandler->moduleExists('geomap_field')) {
      return $types;
    }

    $types[] = new ObjectType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('Complex geomap field data.'),
      'fields' => fn() => [
        'addressName' => Type::string(),
        'street' => Type::string(),
        'zipcode' => Type::string(),
        'city' => Type::string(),
        'country' => Type::string(),
        'additional' => Type::string(),
        'lat' => Type::float(),
        'lon' => Type::float(),
        'feature' => Type::string(),
      ],
    ]);

    return $types;
  }

}
