<?php

declare(strict_types=1);

namespace Drupal\graphql_compose\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Attribute\SchemaType;
use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\Type;

/**
 * {@inheritdoc}
 */
#[SchemaType(
  id: "Language",
)]
class LanguageType extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getTypes(): array {
    $types = [];

    // The configurable_language entity will register the Language type for us.
    if ($this->moduleHandler->moduleExists('language')) {
      return $types;
    }

    // This is the fallback type for LanguageInterface
    // if the language module is not enabled.
    $types[] = new ObjectType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('A language definition provided by the CMS.'),
      'fields' => fn() => [
        'id' => [
          'type' => Type::id(),
          'description' => (string) $this->t('The language code.'),
        ],
        'name' => [
          'type' => Type::string(),
          'description' => (string) $this->t('The language name.'),
        ],
        'direction' => [
          'type' => Type::string(),
          'description' => (string) $this->t('The language direction.'),
        ],
        'weight' => [
          'type' => Type::int(),
          'description' => (string) $this->t('The language weight.'),
        ],
      ],
    ]);

    return $types;
  }

}
