<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_mutations\GraphQL\Response;

use Drupal\Core\Entity\EntityInterface;
use Drupal\graphql\GraphQL\Response\Response;

/**
 * Type of response used when a generic entity is returned.
 */
class GenericEntityResponse extends Response {

  /**
   * The entity to be served.
   *
   * @var \Drupal\Core\Entity\EntityInterface|null
   */
  protected ?EntityInterface $genericEntity = NULL;

  /**
   * The success value to be served.
   *
   * @var bool
   */
  protected bool $success = FALSE;

  /**
   * Sets the entity data.
   *
   * @param \Drupal\Core\Entity\EntityInterface|null $genericEntity
   *   The entity to be served.
   */
  public function setGenericEntity(?EntityInterface $genericEntity): void {
    $this->genericEntity = $genericEntity;
  }

  /**
   * Gets the array values to be served.
   *
   * @return array|null
   *   The array values to be served.
   */
  public function getGenericEntity(): ?array {
    $entity = $this->genericEntity;
    if ($entity) {
      return [
        "values" => $entity->toArray(),
        "id" => $entity->id(),
        "entity_type" => $entity->getEntityTypeId(),
        "entity_bundle" => $entity->bundle(),
      ];
    }
    return NULL;
  }

  /**
   * Gets the success.
   *
   * @return bool
   *   The success to be served.
   */
  public function getSuccess(): bool {
    return $this->success;
  }

  /**
   * Sets the success.
   *
   * @param bool $success
   *   The success value.
   */
  public function setSuccess(bool $success): void {
    $this->success = $success;
  }

}
