<?php

namespace Drupal\graphql_compose_mutations\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_compose_mutations\GraphQL\Response\GenericEntityResponse;

/**
 * Generic Mutation schema.
 *
 * @SchemaExtension(
 *   id = "generic_mutation",
 *   name = "A generic mutation extension",
 *   description = "A simple extension to mutate any entity.",
 *   schema = "graphql_compose"
 * )
 */
class GenericMutationExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver('GenericEntityResponse', 'errors',
      $builder->callback(function (GenericEntityResponse $response) {
        return $response->getViolations();
      })
    );

    $registry->addFieldResolver('GenericEntityResponse', 'success',
      $builder->callback(function (GenericEntityResponse $response) {
        return $response->getSuccess();
      })
    );

    $registry->addFieldResolver('GenericEntityResponse', 'entity',
      $builder->callback(function (GenericEntityResponse $response) {
        return $response->getGenericEntity();
      })
    );

    $registry->addFieldResolver(
      'Mutation',
      'genericMutation',
      $builder->produce('generic_mutation_producer')
        ->map('data', $builder->fromArgument('data'))
        ->map('metadata', $builder->fromArgument('metadata'))
    );

  }

}
