<?php

namespace Drupal\graphql_compose_mutations\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_compose_mutations\GraphQL\Response\OperationsByEntityTypeResponse;

/**
 * Generic Mutation schema.
 *
 * @SchemaExtension(
 *   id = "operations_by_entity_type",
 *   name = "Get operations by entity type",
 *   description = "A query to get operations by entity type extension.",
 *   schema = "graphql_compose"
 * )
 */
class OperationsByEntityTypeExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver('OperationsByEntityTypeResponse', 'errors',
      $builder->callback(function (OperationsByEntityTypeResponse $response) {
        return $response->getViolations();
      })
    );

    $registry->addFieldResolver('OperationsByEntityTypeResponse', 'operations',
      $builder->callback(function (OperationsByEntityTypeResponse $response) {
        return $response->getOperations();
      })
    );

    $registry->addFieldResolver(
      'Query',
      'operationsByEntityType',
      $builder->produce('operations_by_entity_type_producer')
        ->map('entity_type', $builder->fromArgument('entity_type'))
        ->map('parent_entity_type', $builder->fromArgument('parent_entity_type'))
        ->map('parent_entity_id', $builder->fromArgument('parent_entity_id'))
    );
  }

}
