<?php

namespace Drupal\graphql_compose_mutations\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_compose_mutations\GraphQL\Response\PermissionsResponse;

/**
 * Permissions Query schema.
 *
 * @SchemaExtension(
 *   id = "permissions",
 *   name = "A permissions query extension",
 *   description = "A simple extension to get permissions.",
 *   schema = "graphql_compose"
 * )
 */
class PermissionsExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver('PermissionsResponse', 'errors',
      $builder->callback(function (PermissionsResponse $response) {
        return $response->getViolations();
      })
    );

    $registry->addFieldResolver('PermissionsResponse', 'success',
      $builder->callback(function (PermissionsResponse $response) {
        return $response->getSuccess();
      })
    );

    $registry->addFieldResolver(
      'Query',
      'permissions',
      $builder->produce('permissions_producer')
        ->map('operation', $builder->fromArgument('operation'))
        ->map('uid', $builder->fromArgument('uid'))
        ->map('entity_id', $builder->fromArgument('entity_id'))
        ->map('entity_type', $builder->fromArgument('entity_type'))
        ->map('entity_bundle', $builder->fromArgument('entity_bundle'))
        ->map('parent_entity_type', $builder->fromArgument('parent_entity_type'))
        ->map('parent_entity_id', $builder->fromArgument('parent_entity_id'))
    );
  }

}
