# GraphQL Compose Mutations

## About

Provides generic CRUD mutations for any Drupal entity type in your GraphQL schema. Extends [graphql_compose](https://www.drupal.org/project/graphql_compose) to enable create, update, and delete operations without writing schema extensions manually.

## Basic usage

Enable the module to expose mutations:

```graphql
mutation createNode {
  genericMutation(
    data: {
      type: "node"
      bundle: "article"
      operation: CREATE
      values: {
        title: "Hello World"
        body: "Content here"
      }
    }
  ) {
    success
    errors
    entity {
      ... on NodeArticle {
        id
        title
      }
    }
  }
}
```

Query available operations and permissions:

```graphql
query {
  operationsByEntityType(entity_type: "node") {
    bundle
    create
    update
    delete
  }
  permissions(entity_type: "node", bundle: "article", operation: CREATE)
}
```

## Extend and override

- **Decorate `UserPermissions` service** to customize permission logic
- **Implement custom resolvers** for `GenericEntityResponse` fields
- **Hook into entity events** using standard Drupal entity hooks

Example service decoration in `my_module.services.yml`:

```yaml
services:
  my_module.user_permissions:
    class: Drupal\my_module\MyCustomPermissions
    decorates: graphql_compose_mutations.user_permissions
```

## Security notice

**Permission checks are enforced at the data producer level**, not just schema-level. Users must have appropriate Drupal entity permissions (`create {bundle} content`, `edit any {bundle} content`, `delete any {bundle} content`, etc.) for operations to succeed.

Always validate untrusted input and consider adding additional validation layers for public-facing GraphQL endpoints.
