<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_mutations\GraphQL\Response;

use Drupal\graphql\GraphQL\Response\Response;

/**
 * Type of response used when an OperationsByEntityType is returned.
 */
class OperationsByEntityTypeResponse extends Response {

  /**
   * The operations to be served.
   *
   * @var array|null
   */
  protected ?array $operations;

  /**
   * Sets the entity data.
   *
   * @param array|null $operations
   *   The operations to be served.
   */
  public function setOperations(?array $operations): void {
    $this->operations = $operations;
  }

  /**
   * Gets the array values to be served.
   *
   * @return array|null
   *   The array values to be served.
   */
  public function getOperations(): ?array {
    return $this->operations ?? NULL;
  }

}
