<?php

declare(strict_types=1);

namespace Drupal\graphql_compose_mutations\GraphQL\Response;

use Drupal\graphql\GraphQL\Response\Response;

/**
 * Type of response used when a permission is returned.
 */
class PermissionsResponse extends Response {
  /**
   * The access value to be served.
   *
   * @var bool
   */
  protected bool $access = FALSE;

  /**
   * Gets the access.
   *
   * @return bool
   *   The access to be served.
   */
  public function getAccess(): bool {
    return $this->access;
  }

  /**
   * Sets the access.
   *
   * @param bool $access
   *   The access value.
   */
  public function setAccess(bool $access): void {
    $this->access = $access;
  }

  /**
   * Sets the success value.
   */
  public function getSuccess(): bool {
    return $this->access === TRUE;
  }

}
