# The Base Schema

This pages describes the base schema that is generated by the `core_composable` schema.

## Interfaces

### `Entity`

This is the interface which all entity types implement. You can configure which fields should be added.

### `EntityTranslatable`

Interface for all entity types that are configured to be translatable.

### `EntityDescribable`

Interface for all entity types that have a description.

### `EntityLinkable`

Interface for all entity types that define [link templates](https://www.drupal.org/docs/drupal-apis/entity-api/link-templates).

### `FieldItemList`

Implemented by all fields item lists.

### `FieldItemType`

Implemented by all field items.

#### `FieldItemTypeTimestampInterface`

Implemented by all field item types that are `Drupal\Core\Field\Plugin\Field\FieldType\TimestampItem` or `Drupal\datetime\Plugin\Field\FieldType\DateTimeItem`.

#### `FieldItemTypeStringInterface`

Implemented by all field item types that have a `value` property with a `string` data type.

This does not directly correspond to an interface defined by Drupal, but is determined based on the field definition.

#### `FieldItemTypeIntegerInterface`

Implemented by all field item types that have a `value` property with a `integer` data type.

### `Url`

Corresponds to `Drupal\Core\Url`.

### `LanguageInterface`

Corresponds to `Drupal\Core\Language\LanguageInterface`.

Implemented by the `configurable_language` entity type (`Drupal\language\Entity\ConfigurableLanguage`) and the `Language` object (`Drupal\Core\Language\Language`).

## Types

### `Query`

The root query field. A `ping` field is added because at least one field must exist on the type.

### `Mutation`

The root mutation field. A `ping` field is added because at least one field must exist on the type.

### `Language`

Type for the `Drupal\Core\Language\Language` object.

## Enums

### `Langcode`

Generates an enum with a property for every enabled language.

```graphql
enum Langcode {
  """
  German
  """
  DE

  """
  French
  """
  FR

  """
  Italian
  """
  IT
}
```

### `DrupalDateFormat`

Generates an enum describing all configured Drupal date formats.

```graphql
enum DrupalDateFormat {
  """
  14.11.2022
  """
  DATE_SHORT

  """
  2022-11-14
  """
  HTML_DATE

  """
  Montag, 14. November 2022 – 14:52 Uhr
  """
  LONG
}
```

### `EntityType`

Generates an enum with a property for each enabled entity type.

```graphql
enum EntityType {
  """
  File
  """
  FILE

  """
  Media
  """
  MEDIA

  """
  Menu
  """
  MENU

  """
  Content
  """
  NODE

  """
  Paragraph
  """
  PARAGRAPH

  """
  User
  """
  USER
}
```
