<?php

namespace Drupal\graphql_core_schema\EventSubscriber;

use Drupal\graphql_core_schema\Event\AlterEntityFieldEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Alters entity field schema.
 */
class AlterEntityFieldSchemaSubscriber implements EventSubscriberInterface {

  /**
   * Alter configurable_language direction schema type.
   *
   * Originally the direction property is a String, let's turn it into an enum.
   *
   * @param \Drupal\graphql_core_schema\Event\AlterEntityFieldEvent $event
   *   The alter entity field event.
   */
  public function configurableLanguageDirection(AlterEntityFieldEvent $event): void {
    if ($event->getEntityType()->id() === 'configurable_language' &&
        $event->getGqlFieldName() === 'direction' &&
        in_array('language_schema', $event->getSchemaConfiguration()['extensions'])) {
      $event->setGqlFieldSchemaType('LanguageDirection!');
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      AlterEntityFieldEvent::EVENT_NAME => ['configurableLanguageDirection', 0],
    ];
  }

}
