<?php

namespace Drupal\graphql_core_schema\EventSubscriber;

use Drupal\Core\Path\PathMatcher;

/**
 * Sets the frontend context for the current request.
 */
trait FrontpageResetTrait {

  /**
   * The path matcher service.
   *
   * @var \Drupal\Core\Path\PathMatcherInterface
   */
  protected $pathMatcher;

  /**
   * Resets the frontpage context across different services.
   */
  protected function resetFrontpageContext(): void {
    if (!isset($this->pathMatcher)) {
      return;
    }
    // @todo is there a better way to reset this evaluation? There's no public
    // API for this. Maybe injecting a decorated PathMatcher?
    if ($this->pathMatcher instanceof PathMatcher) {
      \Closure::bind(function () {
        unset($this->isCurrentFrontPage);
      }, $this->pathMatcher, PathMatcher::class)();
    }
  }

}
