<?php

namespace Drupal\graphql_core_schema\GraphQL\Enums;

use Drupal\Core\Language\LanguageInterface;
use GraphQL\Type\Definition\EnumType;

/**
 * The LanguageDirection enum.
 */
class LanguageDirectionEnum extends EnumType {

  public function __construct() {
    parent::__construct([
      'name' => 'LanguageDirection',
      'values' => [
        'LTR' => [
          'value' => LanguageInterface::DIRECTION_LTR,
          'description' => 'Left to right',
        ],
        'RTL' => [
          'value' => LanguageInterface::DIRECTION_RTL,
          'description' => 'Right to left',
        ],
      ],
    ]);
  }

}
