<?php

namespace Drupal\graphql_core_schema\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_core_schema\CoreSchemaExtensionInterface;

/**
 * The language_schema extension.
 *
 * @SchemaExtension(
 *   id = "language_schema",
 *   name = "Language Extension"
 * )
 */
class LanguageExtension extends SdlSchemaExtensionPluginBase implements CoreSchemaExtensionInterface {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry) {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver('ConfigurableLanguage', 'direction', $builder->callback(
      function ($language) {
        return strtoupper($language->getDirection());
      })
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeDependencies() {}

  /**
   * {@inheritdoc}
   */
  public function getExtensionDependencies() {}

}
