# GraphQL Extra Cache Module

This module enhances the caching capabilities of GraphQL requests in a Drupal application. It is designed to work with the `graphql` and `graphql_core_schema` modules.

## Features

- The `graphql` module already has a caching layer, but it is implemented too late in the request lifecycle. 
- This module adds a new cache layer that is implemented earlier in the request lifecycle.
- The module skips parsing and validating the whole POST body of the request, which can be a performance bottleneck.
- If the same GraphQL query is requested multiple times, the response will be cached and served from the cache without any additional processing.

This results in a huge performance boost.

## Installation

1. Download and enable the `graphql_extra_cache` module in your Drupal application.
2. Ensure that the `graphql` and `graphql_core_schema` modules are also enabled.

## Usage

Once the module is enabled, it alters graphql the route of `graphql_core_schema` and starts serving from cache.

## Note

This module is designed to work only with the `graphql` and `graphql_core_schema` modules.
