# GraphQL Focal Point

A GraphQL extension module that exposes focal point coordinates for image fields.

## Features

- Adds `focalPoint` field to `FieldItemTypeImage` in GraphQL
- Provides coordinates in multiple formats:
  - Percentage values (0-100)
  - Normalized values (0-1)
  - String formats for both

## Installation

1. Enable the module: `drush en graphql_focal_point`
2. Clear caches: `drush cr`

## Dependencies

- `graphql` (GraphQL 4.x)
- `graphql_core_schema`
- `focal_point`

## Usage

```graphql
query {
  node(id: "123") {
    ... on NodeArticle {
      fieldImage {
        focalPoint {
          x                        # 50 (percentage)
          y                        # 75 (percentage)
          coordinates              # "50,75"
          xNormalized              # 0.5 (0-1 range)
          yNormalized              # 0.75 (0-1 range)
          coordinatesNormalized    # "0.5,0.75"
        }
        url
        alt
      }
    }
  }
}
```

## Schema

```graphql
extend type FieldItemTypeImage {
  focalPoint: FocalPoint
}

type FocalPoint {
  x: Int!
  y: Int!
  coordinates: String!
  xNormalized: Float!
  yNormalized: Float!
  coordinatesNormalized: String!
}
```