<?php

namespace Drupal\graphql_focal_point\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\graphql_core_schema\CoreSchemaExtensionInterface;


/**
 * A schema extension to provide field metadata for fieldable entities.
 *
 * @SchemaExtension(
 *   id = "focal_point",
 *   name = "Focal Point Extension",
 *   description = "Provides focal point coordinates of an image.",
 *   schema = "core_composable"
 * )
 */
class FocalPointExtension extends SdlSchemaExtensionPluginBase implements CoreSchemaExtensionInterface {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeDependencies() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getExtensionDependencies() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry) {
    $builder = new ResolverBuilder();
    
    $registry->addFieldResolver('FieldItemTypeImage', 'focalPoint',
      $builder->produce('focal_point')
        ->map('image', $builder->fromParent())
    );

  }

}
