<?php

namespace Drupal\graphql_search_api_query\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;

/**
 * A schema extension for search api queries.
 *
 * @SchemaExtension(
 *   id = "search_api_query",
 *   name = "Search API Query",
 *   description = "Performs a query on a Search API index.",
 *   schema = "core_composable"
 * )
 */
class SearchApiQueryExtensions extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver('Query', 'searchApiQuery', $builder->compose(
      $builder->produce('search_api_query')
        ->map('index_id', $builder->fromArgument('indexId'))
        ->map('keys', $builder->fromArgument('keys'))
        ->map('filter', $builder->fromArgument('filter'))
        ->map('facets', $builder->fromArgument('facets'))
        ->map('sort', $builder->fromArgument('sort'))
        ->map('limit', $builder->fromArgument('limit'))
        ->map('offset', $builder->fromArgument('offset'))
        ->map('language', $builder->fromArgument('language'))
    ));
  }

}