<?php

namespace Drupal\graphql_twig\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ArgumentValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;

/**
 * Custom argument resolver with specific argument handling.
 *
 * Matches routes generated by GraphQL Twig and massages arguments accordingly.
 *
 * @package Drupal\graphql_twig\Controller
 */
class ArgumentResolver implements ArgumentValueResolverInterface {

  /**
   * @inheritdoc
   */
  public function supports(Request $request, ArgumentMetadata $argument): bool {
    return in_array($argument->getName(), [
      '_graphql_arguments',
      '_graphql_theme_hook',
      '_graphql_title',
      '_graphql_title_query',
    ]);
  }

  /**
   * @inheritdoc
   */
  public function resolve(Request $request, ArgumentMetadata $argument): iterable {
    switch ($argument->getName()) {
      case '_graphql_arguments':
        yield $request->attributes->get('_raw_variables')->all();
        break;

      case '_graphql_theme_hook':
        yield $request->attributes->get('_theme_hook');
        break;

      case '_graphql_title':
        yield $request->attributes->get('_title');
        break;

      case '_graphql_title_query':
        yield $request->attributes->get('_title_query');
        break;
    }
  }

}
