<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementAddress and WebformElementWebformAddress types.
 *
 * @group graphql_webform
 */
class AddressTest extends GraphQLWebformKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['address'];

  /**
   * Tests the address elements.
   */
  public function testAddressElements(): void {
    $query = $this->getQueryFromFile('address.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'elements' => [
          17 => [
            '__typename' => 'WebformElementAddress',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__given_name',
                  'type' => 'textfield',
                  'title' => 'Given name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              1 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__family_name',
                  'type' => 'textfield',
                  'title' => 'Family name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              2 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__additional_name',
                  'type' => 'textfield',
                  'title' => 'Additional name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              3 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__organization',
                  'type' => 'textfield',
                  'title' => 'Organization',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              4 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__address_line1',
                  'type' => 'textfield',
                  'title' => 'Address line 1',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              5 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__address_line2',
                  'type' => 'textfield',
                  'title' => 'Address line 2',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              6 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__postal_code',
                  'type' => 'textfield',
                  'title' => 'Postal code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              7 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__locality',
                  'type' => 'textfield',
                  'title' => 'Locality',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              8 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__dependent_locality',
                  'type' => 'textfield',
                  'title' => 'Dependent_locality',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              9 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__administrative_area',
                  'type' => 'textfield',
                  'title' => 'Administrative area',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              10 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__country_code',
                  'type' => 'textfield',
                  'title' => 'Country code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 2,
              ],
              11 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__langcode',
                  'type' => 'textfield',
                  'title' => 'Language code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 32,
              ],
              12 => [
                'metadata' => [
                  'key' => 'address_using_default_configuration__sorting_code',
                  'type' => 'textfield',
                  'title' => 'Sorting code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
            ],
            'metadata' => [
              'key' => 'address_using_default_configuration',
              'type' => 'address',
            ],
            'multipleValues' => NULL,
          ],
          18 => [
            '__typename' => 'WebformElementAddress',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__given_name',
                  'type' => 'textfield',
                  'title' => 'Given name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              1 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__family_name',
                  'type' => 'textfield',
                  'title' => 'Family name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              2 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__additional_name',
                  'type' => 'textfield',
                  'title' => 'Additional name',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              3 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__organization',
                  'type' => 'textfield',
                  'title' => 'Organization',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              4 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__address_line1',
                  'type' => 'textfield',
                  'title' => 'Address line 1',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              5 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__address_line2',
                  'type' => 'textfield',
                  'title' => 'Address line 2',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              6 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__postal_code',
                  'type' => 'textfield',
                  'title' => 'Postal code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              7 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__locality',
                  'type' => 'textfield',
                  'title' => 'Locality',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              8 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__dependent_locality',
                  'type' => 'textfield',
                  'title' => 'Dependent_locality',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              9 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__administrative_area',
                  'type' => 'textfield',
                  'title' => 'Administrative area',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
              10 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__country_code',
                  'type' => 'textfield',
                  'title' => 'Country code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 2,
              ],
              11 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__langcode',
                  'type' => 'textfield',
                  'title' => 'Language code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 32,
              ],
              12 => [
                'metadata' => [
                  'key' => 'address_using_custom_configuration__sorting_code',
                  'type' => 'textfield',
                  'title' => 'Sorting code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => 255,
              ],
            ],
            'metadata' => [
              'key' => 'address_using_custom_configuration',
              'type' => 'address',
            ],
            'multipleValues' => NULL,
          ],
          19 => [
            '__typename' => 'WebformElementWebformAddress',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'webform_address_value__address',
                  'type' => 'textfield',
                  'title' => 'Address',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => NULL,
              ],
              1 => [
                'metadata' => [
                  'key' => 'webform_address_value__address_2',
                  'type' => 'textfield',
                  'title' => 'Address 2',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => NULL,
              ],
              2 => [
                'metadata' => [
                  'key' => 'webform_address_value__city',
                  'type' => 'textfield',
                  'title' => 'City/Town',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => NULL,
              ],
              3 => [
                'metadata' => [
                  'key' => 'webform_address_value__state_province',
                  'type' => 'select',
                  'title' => 'State/Province',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementSelect',
              ],
              4 => [
                'metadata' => [
                  'key' => 'webform_address_value__postal_code',
                  'type' => 'textfield',
                  'title' => 'ZIP/Postal Code',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementTextfield',
                'maxlength' => NULL,
              ],
              5 => [
                'metadata' => [
                  'key' => 'webform_address_value__country',
                  'type' => 'select',
                  'title' => 'Country',
                  'required' => NULL,
                ],
                '__typename' => 'WebformElementSelect',
              ],
            ],
            'metadata' => [
              'key' => 'webform_address_value',
              'type' => 'webform_address',
            ],
            'multipleValues' => NULL,
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
