<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformCustomComposite type.
 *
 * @group graphql_webform
 */
class CustomCompositeTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the custom composite element.
   */
  public function testCustomCompositeElement(): void {
    $query = $this->getQueryFromFile('custom_composite.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'elements' => [
          16 => [
            '__typename' => 'WebformElementWebformCustomComposite',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'custom_composite_container__first_name',
                  'type' => 'textfield',
                  'title' => 'First name',
                  'required' => NULL,
                ],
              ],
              1 => [
                'metadata' => [
                  'key' => 'custom_composite_container__last_name',
                  'type' => 'textfield',
                  'title' => 'Last name',
                  'required' => NULL,
                ],
              ],
            ],
            'metadata' => [
              'key' => 'custom_composite_container',
              'type' => 'webform_custom_composite',
            ],
            'multipleValues' => ['emptyItems' => 2],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
