<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;
use Drupal\filter\Entity\FilterFormat;

/**
 * Tests for the WebformElementMarkup type.
 *
 * @group graphql_webform
 */
class MarkupTest extends GraphQLWebformKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'filter',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create a filter format for testing the processed text. We only allow the
    // '<strong>' and '<p>' tags. The markup in the test Webform also contains
    // the <em> tag, which should be stripped out in the query result.
    FilterFormat::create([
      'format' => 'basic_html',
      'name' => 'Basic HTML',
      'weight' => 1,
      'filters' => [
        'filter_html' => [
          'status' => 1,
          'settings' => [
            'allowed_html' => '<strong><p>',
          ],
        ],
      ],
    ])->save();
  }

  /**
   * Tests custom markup.
   */
  public function testMarkup(): void {
    $query = $this->getQueryFromFile('markup.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          5 => [
            '__typename' => 'WebformElementWebformMarkup',
            'metadata' => [
              'key' => 'markup',
            ],
            'markup' => '<strong>Markup</strong>',
            'displayOn' => 'DISPLAY_ON_FORM',
          ],
          14 => [
            '__typename' => 'WebformElementProcessedText',
            'metadata' => [
              'key' => 'processed_text',
            ],
            // The '<em>' tag should be stripped out.
            'markup' => '<p><strong>Processed text</strong></p>',
            'displayOn' => 'DISPLAY_ON_BOTH',
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
