<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;
use Drupal\graphql\GraphQL\Execution\ExecutionResult;

/**
 * Tests if we can request information about which elements are required.
 *
 * @group graphql_webform
 */
class RequiredElementTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests querying required elements.
   */
  public function testRequiredElements(): void {
    $query = $this->getQueryFromFile('required.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          0 => [
            'metadata' => [
              'required' => [
                'message' => 'This field is required because it is important.',
              ],
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

  /**
   * {@inheritdoc}
   */
  protected function assertResultData(ExecutionResult $result, $expected): void {
    $data = $result->toArray();
    // Filter out empty data sets from the form elements. This makes it easier
    // to maintain the tests, so we don't have to update them every time some
    // fields are added or removed from the form.
    if (!empty($data['data']['form']['elements'])) {
      $elements = &$data['data']['form']['elements'];
      $elements = array_filter($elements, fn ($value) => !empty($value['metadata']['required']));
    }

    $this->assertArrayHasKey('data', $data, 'No result data.');
    $this->assertEquals($expected, $data['data'], 'Unexpected query result.');
  }

}
