<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Model;

/**
 * Represents a Webform submission validation result.
 */
class WebformSubmissionValidationError {

  /**
   * Constructs a new WebformSubmissionValidationError object.
   *
   * @param string[] $messages
   *   Array of initial validation messages.
   * @param string|null $elementId
   *   The ID of the Webform element the messages refer to.
   */
  public function __construct(
    protected array $messages = [],
    protected ?string $elementId = NULL,
  ) {}

  /**
   * Adds a message to the list of validation messages.
   *
   * @param string $message
   *   The message to add.
   *
   * @return $this
   *   The current instance, for chaining.
   */
  public function addMessage(string $message): self {
    $this->messages[] = $message;
    return $this;
  }

  /**
   * Returns the ID of the Webform element the validation messages refer to.
   *
   * @return string|null
   *   The Webform element ID, or NULL if the messages are not element-specific.
   */
  public function getElementId(): ?string {
    return $this->elementId;
  }

  /**
   * Returns the validation messages.
   *
   * @return string[]
   *   The validation messages.
   */
  public function getMessages(): array {
    return $this->messages;
  }

}
