<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the elements that accept multiple values.
 *
 * @group graphql_webform
 */
class MultipleValuesTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests querying elements that accept multiple values.
   */
  public function testMultipleValues(): void {
    $query = $this->getQueryFromFile('multiple.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          0 => ['multipleValues' => NULL],
          1 => [
            'multipleValues' => [
              'limit' => 2,
              'message' => NULL,
              'headerLabel' => '',
              'minItems' => NULL,
              'emptyItems' => 1,
              'addMore' => TRUE,
              'addMoreItems' => 1,
              'addMoreButtonLabel' => 'Add',
              'addMoreInput' => TRUE,
              'addMoreInputLabel' => 'more items',
              'itemLabel' => 'item',
              'noItemsMessage' => '<p>No items entered. Please add items below.</p>',
              'sorting' => TRUE,
              'operations' => TRUE,
              'add' => TRUE,
              'remove' => TRUE,
            ],
          ],
          2 => [
            'multipleValues' => [
              'limit' => -1,
              'message' => "Please don't check more than @count options.",
              'headerLabel' => NULL,
              'minItems' => NULL,
              'emptyItems' => NULL,
              'addMore' => NULL,
              'addMoreItems' => NULL,
              'addMoreButtonLabel' => NULL,
              'addMoreInput' => NULL,
              'addMoreInputLabel' => NULL,
              'itemLabel' => NULL,
              'noItemsMessage' => NULL,
              'sorting' => NULL,
              'operations' => NULL,
              'add' => NULL,
              'remove' => NULL,
            ],
          ],
          4 => ['multipleValues' => NULL],
          6 => ['multipleValues' => NULL],
          8 => ['multipleValues' => NULL],
          11 => [
            'multipleValues' => [
              'limit' => 2,
              'message' => NULL,
              'headerLabel' => NULL,
              'minItems' => NULL,
              'emptyItems' => NULL,
              'addMore' => NULL,
              'addMoreItems' => NULL,
              'addMoreButtonLabel' => NULL,
              'addMoreInput' => NULL,
              'addMoreInputLabel' => NULL,
              'itemLabel' => NULL,
              'noItemsMessage' => NULL,
              'sorting' => NULL,
              'operations' => NULL,
              'add' => NULL,
              'remove' => NULL,
            ],
          ],
          12 => ['multipleValues' => NULL],
          13 => [
            'multipleValues' => [
              'limit' => 6,
              'message' => NULL,
              'headerLabel' => 'At least two years',
              'minItems' => 2,
              'emptyItems' => 1,
              'addMore' => TRUE,
              'addMoreItems' => 2,
              'addMoreButtonLabel' => 'I want more',
              'addMoreInput' => TRUE,
              'addMoreInputLabel' => 'more items',
              'itemLabel' => 'year',
              'noItemsMessage' => 'We need some years.',
              'sorting' => TRUE,
              'operations' => TRUE,
              'add' => TRUE,
              'remove' => TRUE,
            ],
          ],
          16 => [
            'multipleValues' => [
              'limit' => -1,
              'message' => NULL,
              'headerLabel' => '',
              'minItems' => NULL,
              'emptyItems' => 2,
              'addMore' => TRUE,
              'addMoreItems' => 1,
              'addMoreButtonLabel' => 'Add',
              'addMoreInput' => TRUE,
              'addMoreInputLabel' => 'more items',
              'itemLabel' => 'item',
              'noItemsMessage' => '<p>No items entered. Please add items below.</p>',
              'sorting' => TRUE,
              'operations' => TRUE,
              'add' => TRUE,
              'remove' => TRUE,
            ],
          ],
          19 => ['multipleValues' => NULL],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
