<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementSelect type.
 *
 * @group graphql_webform
 */
class SelectTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests select dropdowns.
   */
  public function testSelect(): void {
    $query = $this->getQueryFromFile('select.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          8 => [
            '__typename' => 'WebformElementSelect',
            'metadata' => [
              'key' => 'select',
              'title' => 'Select',
              'description' => 'Choose wisely.',
            ],
            'options' => [
              0 => [
                'title' => 'Option 1',
                'value' => '1',
                '__typename' => 'WebformElementOption',
              ],
              1 => [
                'title' => 'Option 2',
                'value' => '2',
                '__typename' => 'WebformElementOption',
              ],
            ],
            'emptyOption' => [
              'title' => '- None -',
              'value' => '',
              '__typename' => 'WebformElementOption',
            ],
          ],
          12 => [
            '__typename' => 'WebformElementSelect',
            'metadata' => [
              'key' => 'select_with_custom_empty_option',
              'title' => 'Select with custom empty option',
              'description' => NULL,
            ],
            'options' => [
              0 => [
                'title' => 'Vegetarian',
                'value' => 'vegetarian',
                '__typename' => 'WebformElementOption',
              ],
              1 => [
                'title' => 'Vegan',
                'value' => 'vegan',
                '__typename' => 'WebformElementOption',
              ],
              2 => [
                'title' => 'Gluten free',
                'value' => 'gluten_free',
                '__typename' => 'WebformElementOption',
              ],
              3 => [
                'title' => 'Lactose free',
                'value' => 'lactose_free',
                '__typename' => 'WebformElementOption',
              ],
            ],
            'emptyOption' => [
              'title' => 'No restrictions',
              'value' => 'no_restrictions',
              '__typename' => 'WebformElementOption',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
