<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementTextfield type.
 *
 * @group graphql_webform
 */
class TextFieldTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the text fields.
   */
  public function testTextFields(): void {
    $query = $this->getQueryFromFile('textfield.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          0 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => 'required_text_field',
              'type' => 'textfield',
              'title' => 'Required text field',
              'description' => 'The description of the required text field.',
              'required' => [
                'message' => 'This field is required because it is important.',
              ],
            ],
            'readonly' => FALSE,
            'size' => 10,
            'minlength' => 1,
            'maxlength' => 10,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '',
              'message' => '',
            ],
            'inputMask' => "'casing': 'lower'",
          ],
          1 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => 'optional_text_field',
              'type' => 'textfield',
              'title' => 'Optional text field',
              'description' => NULL,
              'required' => NULL,
            ],
            'readonly' => FALSE,
            'size' => 60,
            'minlength' => NULL,
            'maxlength' => 255,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '',
              'message' => '',
            ],
            'inputMask' => '',
          ],
          13 => [
            '__typename' => 'WebformElementTextfield',
            'metadata' => [
              'key' => '2_years',
              'type' => 'textfield',
              'title' => 'Minimum 2 years, maximum 6',
              'description' => '',
              'required' => NULL,
            ],
            'readonly' => FALSE,
            'size' => 60,
            'minlength' => NULL,
            'maxlength' => 255,
            'placeholder' => '',
            'autocomplete' => 'on',
            'pattern' => [
              'rule' => '\d{4}',
              'message' => 'Please enter a year between 1000 and 9999.',
            ],
            'inputMask' => '',
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
