<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;
use Drupal\graphql\GraphQL\Execution\ExecutionResult;

/**
 * Tests for the WebformElementUnexposed type.
 *
 * This is a fallback for all unsupported element types.
 *
 * @group graphql_webform
 */
class UnexposedElementTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the fallback for unexposed element types.
   */
  public function testUnexposedElementType(): void {
    $query = $this->getQueryFromFile('unexposed.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          3 => [
            '__typename' => 'WebformElementUnexposed',
            'metadata' => [
              'key' => 'unsupported_field',
              'type' => 'webform_element',
              'title' => 'Unsupported field',
              '__typename' => 'WebformElementMetadata',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

  /**
   * {@inheritdoc}
   */
  protected function assertResultData(ExecutionResult $result, $expected): void {
    $data = $result->toArray();

    // Since we have no other conditional fields, everything will be returned as
    // a fallback type. Unset everything but the actual unsupported element.
    $elements = &$data['data']['form']['elements'];
    $elements = array_slice($elements, 3, 1, TRUE);

    $result = new ExecutionResult($data['data'], $data['errors'] ?? [], $data['extensions'] ?? []);
    parent::assertResultData($result, $expected);
  }

}
