<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests the webformById query.
 *
 * @group graphql_webform
 */
class WebformByIdQueryTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the text area.
   */
  public function testQuery(): void {
    $query = $this->getQueryFromFile('webform.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'id' => 'graphql_webform_test_form',
      ],
    ], $this->defaultCacheMetaData());
  }

}
