<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Unit\Enum;

use Drupal\Tests\UnitTestCase;
use Drupal\graphql_webform\Enum\WebformElementDisplayOn;

/**
 * @coversDefaultClass \Drupal\graphql_webform\Enum\WebformElementDisplayOn
 * @group graphql_webform
 */
class WebformElementDisplayOnTest extends UnitTestCase {

  /**
   * @covers ::toArray
   */
  public function testToArray() {
    $expected = [
      'DISPLAY_ON_BOTH' => 'both',
      'DISPLAY_ON_FORM' => 'form',
      'DISPLAY_ON_VIEW' => 'view',
      'DISPLAY_ON_NONE' => 'none',
    ];
    $this->assertEquals($expected, WebformElementDisplayOn::toArray());
  }

  /**
   * @covers ::toGraphQLEnumValue
   */
  public function testToGraphQlEnumValue() {
    $this->assertEquals('DISPLAY_ON_BOTH', WebformElementDisplayOn::DisplayOnBoth->toGraphQlEnumValue());
    $this->assertEquals('DISPLAY_ON_FORM', WebformElementDisplayOn::DisplayOnForm->toGraphQlEnumValue());
    $this->assertEquals('DISPLAY_ON_VIEW', WebformElementDisplayOn::DisplayOnView->toGraphQlEnumValue());
    $this->assertEquals('DISPLAY_ON_NONE', WebformElementDisplayOn::DisplayOnNone->toGraphQlEnumValue());
  }

}
