<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

/**
 * The webform settings that are relevant for a decoupled frontend.
 */
enum ExposedSettings: string {

  case Page = 'page';
  case PageSubmitPath = 'page_submit_path';
  case PageConfirmPath = 'page_confirm_path';

  /**
   * Returns a description for the enum value.
   *
   * @return string
   *   The description.
   */
  public function description(): string {
    return match ($this) {
      self::Page => 'When TRUE, the webform can be accessed and submissions can be posted from a dedicated URL. If FALSE, the webform must be displayed in context of a source entity, such as a node or a block.',
      self::PageSubmitPath => 'The path to use for the webform page. This is only applicable if the webform is accessible from a dedicated URL (i.e. when \'page\' is TRUE).',
      self::PageConfirmPath => 'The path to use for the webform confirmation page. This is only applicable if the webform is accessible from a dedicated URL (i.e. when \'page\' is TRUE).',
    };
  }

  /**
   * Returns the field name to use in GraphQL.
   *
   * @return string
   *   The field name.
   */
  public function toGraphQlFieldName(): string {
    return lcfirst($this->value);
  }

}
