<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

/**
 * Enumerates the possible description placements for webform elements.
 */
enum WebformElementDescriptionDisplay: string {

  case Default = 'default';
  case Before = 'before';
  case After = 'after';
  case Invisible = 'invisible';
  case Tooltip = 'tooltip';

  /**
   * Returns the GraphQL enum values as an associative array.
   *
   * @return array<string, string>
   *   The GraphQL enum values as an associative array.
   */
  public static function toArray(): array {
    $cases = [];
    foreach (self::cases() as $case) {
      $cases[$case->toGraphQlEnumValue()] = $case->value;
    }
    return $cases;
  }

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return match ($this) {
      self::Default => 'DEFAULT',
      self::Before => 'BEFORE',
      self::After => 'AFTER',
      self::Invisible => 'INVISIBLE',
      self::Tooltip => 'TOOLTIP',
    };
  }

}
