<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

/**
 * Enumerates the possible display targets for webform elements.
 *
 * @see \Drupal\webform\Plugin\WebformElementDisplayOnInterface
 */
enum WebformElementDisplayOn: string {

  case DisplayOnBoth = 'both';
  case DisplayOnForm = 'form';
  case DisplayOnView = 'view';
  case DisplayOnNone = 'none';

  /**
   * Returns the GraphQL enum values as an associative array.
   *
   * @return array<string, string>
   *   The GraphQL enum values as an associative array.
   */
  public static function toArray(): array {
    $cases = [];
    foreach (self::cases() as $case) {
      $cases[$case->toGraphQlEnumValue()] = $case->value;
    }
    return $cases;
  }

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return match ($this) {
      self::DisplayOnBoth => 'DISPLAY_ON_BOTH',
      self::DisplayOnForm => 'DISPLAY_ON_FORM',
      self::DisplayOnView => 'DISPLAY_ON_VIEW',
      self::DisplayOnNone => 'DISPLAY_ON_NONE',
    };
  }

}
