<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

/**
 * Enumerates the possible help placements for webform elements.
 */
enum WebformElementHelpDisplay: string {

  case Default = 'default';
  case TitleBefore = 'title_before';
  case TitleAfter = 'title_after';
  case ElementBefore = 'element_before';
  case ElementAfter = 'element_after';

  /**
   * Returns the GraphQL enum values as an associative array.
   *
   * @return array<string, string>
   *   The GraphQL enum values as an associative array.
   */
  public static function toArray(): array {
    $cases = [];
    foreach (self::cases() as $case) {
      $cases[$case->toGraphQlEnumValue()] = $case->value;
    }
    return $cases;
  }

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return match ($this) {
      self::Default => 'DEFAULT',
      self::TitleBefore => 'TITLE_BEFORE',
      self::TitleAfter => 'TITLE_AFTER',
      self::ElementBefore => 'ELEMENT_BEFORE',
      self::ElementAfter => 'ELEMENT_AFTER',
    };
  }

}
