<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

use Drupal\graphql_webform\CaseConverter;

/**
 * Enumerates the possible states for webform elements.
 */
enum WebformElementState: string {

  case Checked = 'checked';
  case Collapsed = 'collapsed';
  case Disabled = 'disabled';
  case Enabled = 'enabled';
  case Expanded = 'expanded';
  case Invisible = 'invisible';
  case InvisibleSlide = 'invisibleSlide';
  case Optional = 'optional';
  case ReadOnly = 'readonly';
  case ReadWrite = 'readwrite';
  case Required = 'required';
  case Unchecked = 'unchecked';
  case Visible = 'visible';
  case VisibleSlide = 'visibleSlide';

  /**
   * Returns the webform state ID as used in the WebformElementStates class.
   *
   * @return string
   *   The webform state ID.
   *
   * @see \Drupal\webform\Element\WebformElementStates::getStateOptions()
   */
  public function toWebformStateId(): string {
    return CaseConverter::toKebabCase($this->value);
  }

}
