<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

use Drupal\graphql_webform\CaseConverter;

/**
 * Enumerates the possible triggers for webform elements.
 */
enum WebformElementTrigger: string {

  case Empty = 'empty';
  case Filled = 'filled';
  case Checked = 'checked';
  case Unchecked = 'unchecked';
  case ValueIs = 'value';
  case ValueIsNot = '!value';
  case Pattern = 'pattern';
  case NotPattern = '!pattern';
  case LessThan = 'less';
  case LessThanEqualTo = 'less_equal';
  case GreaterThan = 'greater';
  case GreaterThanEqualTo = 'greater_equal';
  case Between = 'between';
  case NotBetween = '!between';

  /**
   * Returns the GraphQL enum value.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return CaseConverter::toScreamingSnakeCase($this->value);
  }

}
