<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

use Drupal\webform\WebformInterface;

/**
 * Enumerates the possible confirmation types for webform submissions.
 *
 * @see \Drupal\webform\WebformInterface
 */
enum WebformSubmissionConfirmationType: string {

  case Page = WebformInterface::CONFIRMATION_PAGE;
  case Inline = WebformInterface::CONFIRMATION_INLINE;
  case Message = WebformInterface::CONFIRMATION_MESSAGE;
  case Modal = WebformInterface::CONFIRMATION_MODAL;
  case Url = WebformInterface::CONFIRMATION_URL;
  case UrlMessage = WebformInterface::CONFIRMATION_URL_MESSAGE;
  case None = WebformInterface::CONFIRMATION_NONE;

  /**
   * Returns the GraphQL enum values as an associative array.
   *
   * @return array<string, string>
   *   The GraphQL enum values as an associative array.
   */
  public static function toArray(): array {
    $cases = [];
    foreach (self::cases() as $case) {
      $cases[$case->toGraphQlEnumValue()] = $case->value;
    }
    return $cases;
  }

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return match ($this) {
      self::Page => 'PAGE',
      self::Inline => 'INLINE',
      self::Message => 'MESSAGE',
      self::Modal => 'MODAL',
      self::Url => 'URL',
      self::UrlMessage => 'URL_MESSAGE',
      self::None => 'NONE',
    };
  }

}
