<?php

declare(strict_types=1);

namespace Drupal\graphql_webform\Enum;

/**
 * Enumerates the days of the week.
 *
 * Following PHP date() function pattern: 0 for Sunday through 6 for Saturday.
 */
enum WebformWeekday: int {

  case Sunday = 0;
  case Monday = 1;
  case Tuesday = 2;
  case Wednesday = 3;
  case Thursday = 4;
  case Friday = 5;
  case Saturday = 6;

  /**
   * Returns the GraphQL enum values as an associative array.
   *
   * @return array<string, int>
   *   The GraphQL enum values as an associative array.
   */
  public static function toArray(): array {
    $cases = [];
    foreach (self::cases() as $case) {
      $cases[$case->toGraphQlEnumValue()] = $case->value;
    }
    return $cases;
  }

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string {
    return strtoupper($this->name);
  }

}
