<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\DataProducer;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests the webformById query.
 *
 * @group graphql_webform
 */
class WebformSettingsTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the settings.
   */
  public function testQuery(): void {
    $query = $this->getQueryFromFile('webform_settings.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'settings' => [
          'page' => TRUE,
          'pageSubmitPath' => '',
          'pageConfirmPath' => '',
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
