<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;
use Drupal\graphql\GraphQL\Execution\ExecutionResult;

/**
 * Tests for the WebformElementActions type.
 *
 * @group graphql_webform
 */
class ActionsTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests form submission actions.
   */
  public function testActions(): void {
    $query = $this->getQueryFromFile('actions.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          [
            '__typename' => 'WebformElementWebformActions',
            'submitLabel' => 'Set sail for adventure',
            'metadata' => [
              'key' => 'actions',
              'type' => 'webform_actions',
              'title' => 'Submit button(s)',
              '__typename' => 'WebformElementMetadata',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

  /**
   * {@inheritdoc}
   */
  protected function assertResultData(ExecutionResult $result, $expected): void {
    $data = $result->toArray();
    // The actions are always at the end of the form. We can safely remove all
    // other elements from the result. This makes it easier to maintain the
    // tests since we don't always need to update the element order when adding
    // new elements to the test form.
    $elements = &$data['data']['form']['elements'];
    $elements = array_slice($elements, -1, 1, FALSE);

    $result = new ExecutionResult($data['data'], $data['errors'] ?? [], $data['extensions'] ?? []);
    parent::assertResultData($result, $expected);
  }

}
