<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementCheckboxes type.
 *
 * @group graphql_webform
 */
class CheckboxesTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the checkboxes.
   */
  public function testCheckboxes(): void {
    $query = $this->getQueryFromFile('checkboxes.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          2 => [
            '__typename' => 'WebformElementCheckboxes',
            'options' => [
              [
                'value' => 'phobos',
                'title' => 'Phobos',
                'description' => 'The inner moon of Mars.',
              ],
              [
                'value' => 'deimos',
                'title' => 'Deimos',
                'description' => 'The outer moon of Mars.',
              ],
            ],
            'metadata' => [
              'key' => 'checkboxes',
              'title' => 'Checkboxes',
              'description' => 'Choose your moons.',
              'defaultValue' => '["phobos","deimos"]',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
