<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;
use Drupal\graphql_webform\Enum\WebformWeekday;

/**
 * Tests for date based elements.
 *
 * @group graphql_webform
 */
class DateBasedElementsTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests that date based return the date specific properties.
   */
  public function testFlexbox(): void {
    $query = $this->getQueryFromFile('date.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'elements' => [
          20 => [
            '__typename' => 'WebformElementDate',
            'min' => (new \DateTime('today'))->format('Y-m-d'),
            'max' => (new \DateTime('+2 weeks'))->format('Y-m-d'),
            'allowedDays' => [
              'MONDAY',
              'TUESDAY',
              'WEDNESDAY',
              'THURSDAY',
              'FRIDAY',
            ],
          ],
          21 => [
            '__typename' => 'WebformElementDatetime',
            'min' => NULL,
            'max' => NULL,
            'allowedDays' => array_map(fn (WebformWeekday $day) => $day->toGraphQlEnumValue(), WebformWeekday::cases()),
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
