<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementFieldset type.
 *
 * @group graphql_webform
 */
class FieldsetTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the fieldset element.
   */
  public function testFieldset(): void {
    $query = $this->getQueryFromFile('fieldset.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          15 => [
            '__typename' => 'WebformElementFieldset',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'checkbox2',
                  'type' => 'checkbox',
                ],
              ],
            ],
            'metadata' => [
              'key' => 'fieldset',
              'type' => 'fieldset',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
