<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementFlexbox type.
 *
 * @group graphql_webform
 */
class FlexboxTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests the flexbox element.
   */
  public function testFlexbox(): void {
    $query = $this->getQueryFromFile('flexbox.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          10 => [
            '__typename' => 'WebformElementWebformFlexbox',
            'alignItems' => 'center',
            'elements' => [
              0 => [
                'metadata' => [
                  'key' => 'checkbox',
                  'flex' => '10',
                ],
              ],
              1 => [
                'metadata' => [
                  'key' => 'time',
                  'flex' => '1',
                ],
              ],
            ],
            'metadata' => [
              'key' => 'flexbox',
              'type' => 'webform_flexbox',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
