<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for numeric field types.
 *
 * @group graphql_webform
 */
class NumericFieldsTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests numeric field types.
   */
  public function testNumericFields(): void {
    $query = $this->getQueryFromFile('numeric_fields.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'elements' => [
          22 => [
            'elements' => [
              0 => [
                '__typename' => 'WebformElementNumber',
                'min' => NULL,
                'max' => NULL,
                'step' => 0,
                'metadata' => [
                  'defaultValue' => '"2"',
                ],
              ],
              1 => [
                '__typename' => 'WebformElementNumber',
                'min' => 0,
                'max' => 1000,
                'step' => 100,
                'metadata' => [
                  'defaultValue' => '"100"',
                ],
              ],
              2 => [
                '__typename' => 'WebformElementWebformScale',
                'min' => 1,
                'max' => 5,
                'metadata' => [
                  'defaultValue' => '"3"',
                ],
              ],
              3 => [
                '__typename' => 'WebformElementWebformRating',
                'max' => 5,
                'metadata' => [
                  'defaultValue' => '5',
                ],
              ],
              4 => [
                '__typename' => 'WebformElementRange',
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'metadata' => [
                  'defaultValue' => '"22"',
                ],
              ],
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
