<?php

declare(strict_types=1);

namespace Drupal\Tests\graphql_webform\Kernel\Element;

use Drupal\Tests\graphql_webform\Kernel\GraphQLWebformKernelTestBase;

/**
 * Tests for the WebformElementRadios type.
 *
 * @group graphql_webform
 */
class RadiosTest extends GraphQLWebformKernelTestBase {

  /**
   * Tests radio buttons.
   */
  public function testRadios(): void {
    $query = $this->getQueryFromFile('radios.gql');
    $this->assertResults($query, ['id' => 'graphql_webform_test_form'], [
      'form' => [
        'title' => 'GraphQL Webform test form',
        'elements' => [
          7 => [
            '__typename' => 'WebformElementRadios',
            'options' => [
              0 => [
                'title' => 'Radio Tirana',
                'value' => 'tirana',
                '__typename' => 'WebformElementOption',
                'description' => 'Broadcasting from Albania since 1937',
              ],
              1 => [
                'title' => 'Radio Pacifico',
                'value' => 'pacifico',
                '__typename' => 'WebformElementOption',
                'description' => 'Broadcasts from Peru since 1964',
              ],
            ],
            'metadata' => [
              'key' => 'radios',
              'type' => 'radios',
              'title' => 'Radios',
              'description' => 'Choose your favorite station.',
              'required' => FALSE,
              'requiredError' => NULL,
              'defaultValue' => '"pacifico"',
            ],
          ],
        ],
      ],
    ], $this->defaultCacheMetaData());
  }

}
